<?php
include_once("MySqlConnection.class.php");

class Formulario
{
	private $oMySql;
	private $pagina_actual;
	private $resultados_por_pagina;
	private $strSql;
	private $limite;
	private $totalFormularios;
	
	function __construct($pUserName)
  	{
		$this->oMySql = new MySqlConnection();
		$this->pagina_actual = 0;
		$this->resultados_por_pagina = 10;
	}
	
	/**
	 * @desc Recupera de la base los formularios segun los parametros enviados.
	 * @param &lt;array&gt;  $arrFiltro
	 * @param &lt;string&gt; $strFechaDesde
	 * @param &lt;string&gt; $strFechaHasta
	 * @param &lt;array&gt;  $arrOrdenamiento
	 * @param &lt;int&gt;    $pagina
	 * @return Retorna un arreglo con los resultados de la busqueda: 
	 * 		   &lt;array&gt; $arr[$i]['&lt;nombre_campo_base&gt;'] 
	 */
	function getFormularios($arrFiltro = NULL,$strFechaDesde = "",$strFechaHasta = "",$arrOrdenamiento = NULL,$pagina = -1,$blTiempoDesarrollo = false,$strGrupo = "",$strTipoFecha = 1,$strcia="")
	{	
		//$this->pagina_actual = $pagina;
		if(count($arrFiltro) > 0)
		{
			$strFiltro = "";
			reset($arrFiltro);
			while(list($key, $value) = each($arrFiltro))
				 { $strFiltro .= " AND b.". $key." = '".$value."' "; }
		}
		else
		{
			$strFiltro = "";
		}
		
		if($blTiempoDesarrollo == true)
		{
			$strTiempoDesarrollo = " and TIME_TO_SEC(b.tiempo_desarrollo) > 0 ";
		}
		else
		{
			$strTiempoDesarrollo = "";
		}
		
		if($strGrupo != "")
		{
			$strFormsPorGrupo = " and a.grupo = '".$strGrupo."' ";
		}
		else
		{
			$strFormsPorGrupo = "";
		}
		if($strcia != "" and $strcia!="0")
		{
			$strFormsPorCia = " and a.id_clientes = '".$strcia."' ";
		}
		else
		{
			$strFormsPorCia = "";
		}
		if($strTipoFecha == 1)
		{
			$strDesde = ($strFechaDesde != "")? " AND fecha >= '".$strFechaDesde."'" : "";
			$strHasta = ($strFechaHasta != "")? " AND fecha <= '".$strFechaHasta."'" : "";
		}
		else
		{
			$strDesde = ($strFechaDesde != "")? " AND fecha_solucion >= '".$strFechaDesde."'" : "";
			$strHasta = ($strFechaHasta != "")? " AND fecha_solucion <= '".$strFechaHasta."'" : "";
		}
		$strOrdenamiento = (count($arrOrdenamiento) > 0)? " ORDER BY ".implode(",",$arrOrdenamiento) : "";
		$arrFormularios = array();
		$this->strSql = "SELECT	a.compania,
								a.costo,
								b.*,
								(SELECT descripcion 
							 	FROM estados WHERE 
							 	id = b.estado_actual
								) as desc_estado
						FROM clientes a,formulario b
						WHERE a.id_clientes = b.id_clientes
						".$strDesde."
						".$strHasta."
						".$strFiltro."
						".$strTiempoDesarrollo."
						".$strFormsPorGrupo."
						".$strFormsPorCia."
						".$strOrdenamiento;
		//echo $this->strSql;
		if($pagina >= 0)
		{
			$this->pagina_actual = $pagina;
			$this->limite = " LIMIT ".($this->pagina_actual * $this->resultados_por_pagina).",".$this->resultados_por_pagina;
		}
		else
		{
			$this->pagina_actual = 0;
			$this->limite = "";
		}
		
		$this->limite = " LIMIT ".($this->pagina_actual * $this->resultados_por_pagina).",".$this->resultados_por_pagina;
		//echo $this->strSql."<br>";
		$this->oMySql->execute($this->strSql);
		$this->totalFormularios	= $this->oMySql->get_num_rows();
		$this->oMySql->execute($this->strSql.$this->limite);
		
		$arrFormularios = $this->oMySql->get_rows();
		
		return $arrFormularios;
	}
	
	
	function getNumFormularios()
	{ return $this->totalFormularios; }
	
	
	function getTotalHoras()
	{ 
		$strSql = "	SELECT SEC_TO_TIME( sum( TIME_TO_SEC( tiempo_facturado ) ) ) as tiempo_total_facturado
					FROM ( ".$this->strSql.$this->limite." ) as MyTable ";
		$this->oMySql->execute($strSql);
		$arrTiempoFacturado = $this->oMySql->get_rows();
		
		return ($arrTiempoFacturado[0]["tiempo_total_facturado"] == "")? "00:00" : $arrTiempoFacturado[0]["tiempo_total_facturado"];
	}
	
	
	function getTotalHorasDesarrollo()
	{
		$strSql = "	SELECT SEC_TO_TIME( sum( TIME_TO_SEC( tiempo_desarrollo ) ) ) as tiempo_total_realizado
					FROM ( ".$this->strSql.$this->limite." ) as MyTable ";
		$this->oMySql->execute($strSql);
		$arrTiempoFacturado = $this->oMySql->get_rows();
		
		return ($arrTiempoFacturado[0]["tiempo_total_realizado"] == "")? "00:00" : $arrTiempoFacturado[0]["tiempo_total_realizado"];
	}
	
	
	function getClientesEnFormularios()
	{
		$strSql = "	SELECT DISTINCT id_clientes AS id_cliente 
					FROM ( ".$this->strSql.$this->limite." ) as MyTable ";
		$this->oMySql->execute($strSql);
		$arrClientes = $this->oMySql->get_rows();
		//echo $strSql."<br>";
		return $arrClientes;
	}
	
	
	function getResultadosPorPagina()
	{
		return $this->resultados_por_pagina;
	}
}
?>